<?php

// NOTES
// This is a affiliate_product_rate for creating CRUD resources.
// Do not edit this file.
// To customize do the following once you copy and paste it:
// [ ] replace "AffiliateProductRate" with your model name (uppercase and singular)
// [ ] replace "affiliate_product_rate" with your model name (lowercase and singular)

namespace SolidAffiliate\Controllers;

use SolidAffiliate\Lib\ControllerFunctions;
use SolidAffiliate\Lib\URLs;
use SolidAffiliate\Lib\Validators;
use SolidAffiliate\Lib\VO\Either;
use SolidAffiliate\Lib\VO\Schema;
use SolidAffiliate\Lib\VO\SchemaEntry;
use SolidAffiliate\Models\AffiliateProductRate;
use SolidAffiliate\Views\Admin\AffiliateProductRates\EditView;
use SolidAffiliate\Views\Admin\AffiliateProductRates\NewView;
use SolidAffiliate\Views\Shared\AdminHeader;
use SolidAffiliate\Views\Shared\DeleteResourceView;
use SolidAffiliate\Views\Shared\WPListTableView;


/**
 * AffiliateProductRatesController
 * 
 * @psalm-suppress PropertyNotSetInConstructor
 */
class AffiliateProductRatesController
{
    const POST_PARAM_SUBMIT = 'submit_affiliate_product_rate';
    const NONCE_SUBMIT = 'solid-affiliate-affiliate_product_rates-new';

    const POST_PARAM_DELETE = 'delete_affiliate_product_rate';
    const NONCE_DELETE = 'solid-affiliate-affiliate_product_rates-delete';


    /**
     * @since 1.0.0
     *
     * @return void
     */
    public static function admin_root()
    {
        $action = isset($_GET["action"]) ? (string)$_GET["action"] : "index";

        switch ($action) {
            case "index":
                AffiliateProductRatesController::GET_admin_index();
                break;
            case "new":
                AffiliateProductRatesController::GET_admin_new();
                break;
            case "edit":
                $ids = ControllerFunctions::extract_ids_from_get($_GET);
                AffiliateProductRatesController::GET_admin_edit($ids[0]);
                break;
            case "delete":
                $ids = ControllerFunctions::extract_ids_from_get($_GET);
                AffiliateProductRatesController::GET_admin_delete($ids);
                break;
            default:
                AffiliateProductRatesController::GET_admin_index();
                break;
        }
    }

    /**
     * @return void
     */
    public static function GET_admin_index()
    {
        $o = WPListTableView::render(AffiliateProductRate::ADMIN_PAGE_KEY, AffiliateProductRate::admin_list_table(), __('Affiliate Product Rates', 'solid-affiliate'));
        echo ($o);
    }

    /**
     * @return void
     */
    public static function GET_admin_new()
    {
        echo NewView::render();
    }

    /**
     * @param int $id
     *
     * @return void
     */
    public static function GET_admin_edit($id)
    {
        $maybe_visit = AffiliateProductRate::find($id);
        if (is_null($maybe_visit)) {
            _e('Not found', 'solid-affiliate');
        } else {
            $item = (object)$maybe_visit->attributes;
            echo EditView::render($item);
        }
    }


    /**
     * @param array<int> $ids
     *
     * @return void
     */
    public static function GET_admin_delete($ids)
    {
        $delete_view_configs = [
            'singular_name' => __('Affiliate Product Rate', 'solid-affiliate'),
            'plural_name' => __('Affiliate Product Rates', 'solid-affiliate'),
            'form_id' => 'affiliate_product_rates-new',
            'nonce' => AffiliateProductRatesController::NONCE_DELETE,
            'submit_action' => AffiliateProductRatesController::POST_PARAM_DELETE,
            'children_classes' => []
        ];

        $o = DeleteResourceView::render($delete_view_configs, $ids);
        echo ($o);
    }

    /**
     * Creates the Resource
     *
     * @return void
     */
    public static function POST_admin_create_and_update_handler()
    {
        $args   = [
            'page' => AffiliateProductRate::ADMIN_PAGE_KEY,
            'class_string' => AffiliateProductRate::class,
            'success_msg_create' => __('Successfully created Affiliate Product Rate', 'solid-affiliate'),
            'success_msg_update' => __('Successfully updated Affiliate Product Rate', 'solid-affiliate'),
            'error_msg' => __('There was an error updating Affiliate Product Rate.', 'solid-affiliate'),
            'schema' => AffiliateProductRate::schema(),
            'upsert_function' =>
            /** 
             * @param array<string, mixed> $args
             * @return Either<int> */
            function ($args) {
                return AffiliateProductRate::upsert($args);
            },
            'capability' => 'read'
        ];

        ControllerFunctions::generic_upsert_handler($_POST, $args);
    }

    /**
     * @since 1.0.0
     *
     * @hook admin_init
     *
     * @return void
     */
    public static function POST_admin_delete_handler()
    {
        ////////////////////////////////////////////////////////////////////////
        // variables
        $args = [
            'page' => AffiliateProductRate::ADMIN_PAGE_KEY,
            'success_msg' => __('Successfully deleted Affiliate Product Rate', 'solid-affiliate'),
            'error_msg' => __('There was an error.', 'solid-affiliate'),
            'delete_by_id_function' =>
            /**
             * @param int $id
             * 
             * @return Either<int>
             */
            function ($id) {
                return AffiliateProductRate::delete($id, true);
            },
        ];

        ControllerFunctions::generic_delete_handler($_POST, $args);
        ////////////////////////////////////////////////////////////////////////
    }

    /**
     * @return void
     */
    public static function POST_admin_table_bulk_actions_handler()
    {
        $schema = new Schema(['entries' =>
        [
            'id' => new SchemaEntry([
                'type' => 'varchar',
                'is_enum' => true,
                'display_name' => 'id'
            ]),
            'action' => new SchemaEntry([
                'type' => 'varchar',
                'display_name' => 'action'
            ]),
        ]]);


        $eitherPostParams = ControllerFunctions::extract_and_validate_POST_params(
            $_POST,
            ['id', 'action'],
            $schema
        );

        if ($eitherPostParams->isLeft) {
            ControllerFunctions::handle_redirecting_and_exit('REDIRECT_BACK', $eitherPostParams->left);
        } else {
            $bulk_action_string = (string)$eitherPostParams->right['action'];
            // TODO the idea is that we can encode the data type requirement in a Schema entry,
            // and ControllerFunctions::extract_and_validate_POST_params should take care of ensureing the type.
            // So we wouldn't need to do this below Validator.
            $ids = Validators::array_of_int($eitherPostParams->right['id']);

            switch ($bulk_action_string) {
                case 'Activate':
                    $affiliate_product_rates = AffiliateProductRate::find_many($ids);
                    AffiliateProductRate::updateInstances($affiliate_product_rates, ['status' => 'active']);
                    break;
                case 'Deactivate':
                    $affiliate_product_rates = AffiliateProductRate::find_many($ids);
                    AffiliateProductRate::updateInstances($affiliate_product_rates, ['status' => 'inactive']);
                    break;
                case 'Delete':
                    $delete_url = URLs::delete(AffiliateProductRate::class, true);
                    ControllerFunctions::handle_redirecting_and_exit($delete_url, [], [], 'admin', ['id' => $ids]);
                    break;
                default:
                    ControllerFunctions::handle_redirecting_and_exit('REDIRECT_BACK', ["Invalid bulk action: {$bulk_action_string}"], [], 'admin');
                    break;
            }

            ControllerFunctions::handle_redirecting_and_exit('REDIRECT_BACK', [], [__('Update Successful', 'solid-affiliate')]);
        };
    }
}
