<?php
// NOTES
// This is a template for creating CRUD resources.
// Do not edit this file.
// To customize do the following once you copy and paste it:
// [ ] replace "Template" with your model name (uppercase and singular)
// [ ] replace "template" with your model name (lowercase and singular)

namespace SolidAffiliate\Views\Admin\Templates;

use SolidAffiliate\Controllers\TemplatesController;
use SolidAffiliate\Lib\FormBuilder\FormBuilder;
use SolidAffiliate\Models\Template;

class NewView
{

    /**
     * @return string
     */
    public static function render()
    {
        $singular = 'Template';
        $form_id = 'templates-new';
        $schema = Template::schema();
        $nonce = TemplatesController::NONCE_SUBMIT_CREATIVE;
        $submit_action = TemplatesController::POST_PARAM_SUBMIT_CREATIVE;

        $form = FormBuilder::render_crud_form_new($schema, $submit_action, $nonce, $form_id, $singular);
        ob_start();
?>
        <div class="wrap">
            <h1><?php _e("Add New {$singular}", 'solid-affiliate'); ?></h1>
            <?php echo $form ?>
        </div>

<?php
        return ob_get_clean();
    }
}
