

const template = `
<div class="q-pa-md">
    <div>
        
        <div class="row q-col-gutter-md row-eq">
            <div class="col-md-6 col-12">
                <div class="card-item">
                    <q-chip icon="event">Tạo URL giới thiệu</q-chip>
                    <div class="flex q-mt-md space-bw">
                        <q-input filled v-model="url" label="Nhập URL cần tạo đường dẫn giới thiệu" style="width:80%" dense/>
                        <q-btn color="primary" style="width:18%;" @click="createAffUrl" size="sm">Tạo URL</q-btn>
                        <p class="q-mt-md">
                            Bạn có thể sao chép URL sản phẩm, URL danh mục hoặc bất kì URL nào để tạo
                            đường dẫn giới thiệu cho người mua
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-12">
                <div class="card-item" v-if="Object.keys(settings).length && !isNormal()">
                    <q-chip icon="event">Chia sẻ URL đăng kí cho cộng tác viên</q-chip>
                    <div class="flex q-mt-md space-bw">
                        <q-input filled v-model="register_link"  style="width:80%" dense />
                        <q-btn color="primary" style="width:18%;" @click="copyRegisterLink" size="sm">COPY</q-btn>
                        <p class="q-mt-md">
                            Bạn có thể tuyển cộng tác viên cấp dưới theo URL này
                        </p>
                    </div>
                </div>
            </div>
        </div>
            
    </div>
</div>
`;

const { RV_CONFIGS } = window 
export default {
    data: () => ({
        configs: RV_CONFIGS,
        isLoading: true,
        settings: {},
        url: '',
        register_link: ''

    }),
   
    methods: {
       createAffUrl() {
        if (this.url == "") {
            this.$notify("URL không thể để trống", 0);
            return;
        }
        const ref_value = 'ref_value_is_id' in this.settings && this.settings.ref_value_is_id ? 'user_id' :'user_login'
        const final_url =
            this.url.split('?')[0] + "?"+this.settings.ref_name+"=" + this.configs[ref_value];

        let site_url = this.configs.site_url
            site_url = site_url.replaceAll('https://', '')
            site_url = site_url.replaceAll('http://', '')

        if(this.url.indexOf(site_url) == -1)
            return this.NOTIFY('Tên miền không hợp lệ', false)

        this.$q.dialog({
                title: "Chia sẻ link giới thiệu",
                message: final_url,
                cancel: false,
                ok: {
                    label: 'Sao chép'
                },
                persistent: true
            })
            .onOk(() => {
                this.NOTIFY('Sao chép thành công')
                
                Quasar.utils.copyToClipboard(final_url)
            });
        },
        copyRegisterLink(){
            Quasar.utils.copyToClipboard(this.register_link)
            this.NOTIFY('Sao chép thành công')
        }
	},
	components:{
       
	},
    watch:{

    },
    template: template,
    created(){
         this.getConfigs().then(res => {
            this.settings = res
            const ref_value = 'ref_value_is_id' in this.settings && this.settings.ref_value_is_id ? 'user_id' :'user_login'
            this.register_link = this.settings.aff_user_page + '/#/dang-ky?' + this.settings.ref_name + '=' + this.configs[ref_value]
        })
        this.$eventBus.$emit('set.page_title', 'Công cụ hỗ trợ');
    }

}